//=============================================================================
// ExtraCritical_HitJudgeCustom.js
// ----------------------------------------------------------------------------
// (C)2022 kuroame koubou
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 0.9.0 2022/07/17 初版
// ----------------------------------------------------------------------------
// [Blog]   : http://kuroamekoubou.blog.fc2.com
// [Twitter]: https://twitter.com/kuroVelter9623
//=============================================================================

/*:
 * @plugindesc 多段クリティカル機構追加機能_命中判定変更
 * @target MZ
 * @author くろあめ
 * 
 * @param Prob Eva AgiMax
 * @text 敏捷補正確率限界閾値
 * @desc 敏捷の差で、回避率が変動する最大の差分倍率です。初期設定の3なら3倍以上の差は無視されます。
 * @default 3
 * @type number
 *
 * @help
 * ツクールの標準の「命中判定」「回避判定」の二つに成功して
 * はじめて命中したと判断する命中計算式を
 * 「スキル命中率*(使用者の命中率-対象の回避率) ＞ 乱数」に置き換えます
 * また、回避判定に攻撃者と対象の敏捷を加味するようになります。
 * 
 * スキル・アイテムのメモ欄に <PlusAim:n> と記述することで 
 * スキル・アイテムの成功率にｎ％を加算することができます
 * これにより、100％超えの成功率を持つスキル・アイテムを作成できます。
 * （命中率の低い使用者を補ったり、高回避率の敵に当たりやすいスキルが作成できます）
 *
 * 追加機能として、アクターが、単体を対象に取る攻撃行動を決定する際に
 * エネミー選択時に、予測命中率と予測必殺率を表示します。
 *
 * このプラグインは、多段クリティカル機構プラグイン
 * 「ExtraCritical.js」に機能追加を行うプラグインです
 * 動作には本体である「ExtraCritical.js」導入が前提となります
 * 必ず「ExtraCritical.js」より下に導入してください。
 *
 * このプラグインは、戦闘計算で使われる各種関数を再定義する都合上
 * 非常に競合性の高い作りになっています
 * ほかの戦闘計算式系スクリプトと共存させるときには
 * 細心の注意を払ってください。
 *
 *
 * 利用形態（商用、18禁利用等）について制限はありません
 * 作者への使用報告や、ReadMeなどへ作者・サイト名の記載も任意となります。
 *
 * ただし、作者はこれらのプラグインについて
 * 基本的に一切のサポートを行いません
 * 何か問題が起きた時、ご自身で解決できる方のみご利用ください。
 */


(function() {

const parameters     = PluginManager.parameters('ExtraCritical');
const crtMax         = Number(parameters['Critical Max']);

const parameters2    = PluginManager.parameters('ExtraCritical_HitJudgeCustom');
const ProbEvaAgiMax  = Number(parameters2['Prob Eva AgiMax']);


/* 都合上、元処理は退避するだけで呼び出さない 処理ごと再定義 */
const _Game_Action_itemHit_og_HJC = Game_Action.prototype.itemHit;
Game_Action.prototype.itemHit = function(target) {
    var plusAim = 0;
    if (this.item() && this.item().meta && this.item().meta.PlusAim) plusAim = Number(this.item().meta.PlusAim);
    const successRate = this.item().successRate + plusAim;
    if(this.isPhysical() || this.isMagical()){
        var fullEva = target.eva;
        if(target.agi >= this.subject().agi){
           var probPlus = Math.min(target.agi / this.subject().agi, ProbEvaAgiMax);
           probPlus = (probPlus - 1.0) / 2;
           probPlus = 1.0 + probPlus;
           fullEva = fullEva * probPlus;
        }
        fullEva = Math.min(fullEva,0.95);
        var lastEva = 1.0 - fullEva
        return successRate * 0.01 * this.subject().hit * lastEva;
    }else{
        return successRate * 0.01;
    }
};

/* 都合上、元処理は退避するだけで呼び出さない 処理ごと再定義 */
const _Game_Action_apply_og_HJC = Game_Action.prototype.apply;
Game_Action.prototype.apply = function(target) {
    const result = target.result();
    this.subject().clearResult();
    result.clear();
    result.used = this.testApply(target);
    result.missed = result.used && Math.random() >= this.itemHit(target);
    result.evaded = false;
    result.physical = this.isPhysical();
    result.drain = this.isDrain();
    if (result.isHit()) {
        if (this.item().damage.type > 0) {
/* ここから処理変更 */
            result.critical = false;
            result.critical_lv = 0;
            
            var cricnt=1;
            if (this.item().meta.CriLevelFix){
                cricnt=Number(this.item().meta.CriLevelFix);
                result.critical = true;
                result.critical_lv = cricnt;
            }
            if (cricnt>=crtMax){
                cricnt=crtMax
                result.critical_lv = cricnt;
            }
            
            for(cricnt; cricnt<=crtMax; cricnt++){
                if(Math.random() < this.itemCri(target,cricnt)){
                    result.critical = true;
                    result.critical_lv = cricnt;
                }else{
                    break;
                }
            }
/* ここまで処理変更 */
            const value = this.makeDamageValue(target, result.critical);
            this.executeDamage(target, value);
        }
        for (const effect of this.item().effects) {
            this.applyItemEffect(target, effect);
        }
        this.applyItemUserEffect(target);
    }
    this.updateLastTarget(target);
};

//=========================================================
// ここから、対象名＋命中率＆必殺率表示
//=========================================================

BattleManager.makeTargetHitAndCriProb = function(enemy) {
    if(!enemy) return "";
    if(!this.actor()) return "";
    return this.actor().dispHitAndCriProb(enemy,this.actor());
}

Game_Actor.prototype.dispHitAndCriProb = function(enemy, actor) {
    
    var dispname = "";
    if (!enemy) return dispname;
    dispname += enemy.name();
    
    if(actor){
        //console.log(BattleManager.actor());
        //console.log(BattleManager.actor()._actionInputIndex);
        
        if(  BattleManager.actor()._actions[BattleManager.actor()._actionInputIndex]._item._dataClass && 
             BattleManager.actor()._actions[BattleManager.actor()._actionInputIndex]._item._dataClass == "skill"
        ){
        
            const hit_rate = Math.floor(BattleManager.actor()._actions[BattleManager.actor()._actionInputIndex].itemHit(enemy) * 100);
            const cri_rate = Math.floor(BattleManager.actor()._actions[BattleManager.actor()._actionInputIndex].itemCri(enemy,1) * 100);
            
            dispname += " (HIT:"+ hit_rate + "% / CRI:"+ cri_rate +"%)";
        }
    }
    return dispname;
    //console.log(BattleManager.actor().lastBattleSkill());
}
})();

